package com.hero.ui.dialog;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Entangle;
import com.hero.objects.powers.Power;
import com.hero.objects.powers.SenseAdder;
import com.hero.ui.widgets.LevelTF;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class PowerDialog extends GenericDialog {
	private static final long serialVersionUID = 5901102773385534530L;

	protected Power power;

	protected JLabel damageLbl;

	protected JCheckBox useStandardEffectCB;

	protected JComboBox affectsCombo;

	protected JLabel affectsLbl;

	protected JLabel quantityLbl;

	protected LevelTF quantityTF;

	public PowerDialog(Power pow, boolean isNew, boolean isPower) {
		super(pow, isNew, isPower);
		if (isNew) {
			// default the standard effect selection...
			if (pow.standardEffectAllowed()) {
				pow.setUseStandardEffect(HeroDesigner.getActiveHero()
						.getRules().defaultStandardEffect());
			}
		}
		power = pow;
		init();
	}

	public PowerDialog(Power pow, boolean isNew, boolean isPower, boolean init) {
		super(pow, isNew, isPower);
		if (isNew) {
			// default the standard effect selection...
			if (pow.standardEffectAllowed()) {
				pow.setUseStandardEffect(HeroDesigner.getActiveHero()
						.getRules().defaultStandardEffect());
			}
		}
		power = pow;
		if (init) {
			init();
		}
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 10;
		gbc.weightx = 1;
		gbc.weighty = 1;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);
		gbc.gridx = 2;
		gbc.gridwidth = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridy = 70;
		if ((power.getLevelCost() > 0) && (power.getLevelValue() > 0)) { // levelTF
			// visible
			panel.add(damageLbl, gbc);
		}
		gbc.gridy = 71;
		gbc.gridx = 0;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		if (HeroDesigner.getActiveHero().getRules().isStandardEffectAllowed()
				&& power.standardEffectAllowed()) {
			panel.add(useStandardEffectCB, gbc);
		}

		gbc.gridwidth = 1;
		gbc.gridx = 0;
		gbc.gridy = 84;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.anchor = GridBagConstraints.EAST;
		panel.add(quantityLbl, gbc);
		gbc.gridx = 1;
		gbc.gridwidth = 2;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(quantityTF, gbc);

		gbc.gridwidth = 1;
		gbc.gridx = 0;
		gbc.gridy = 75;
		gbc.weightx = 0;
		gbc.weighty = 0;
		panel.add(affectsLbl, gbc);
		gbc.gridx = 1;
		gbc.gridwidth = 2;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(affectsCombo, gbc);

		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		useStandardEffectCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				power.setUseStandardEffect(useStandardEffectCB.isSelected());
				updateValues();
			}
		});
		quantityTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						if (power.getQuantity() == quantityTF.getCurrent()) {
							return;
						}
						power.setQuantity(quantityTF.getCurrent());
						GenericObject.lastEdit = System.currentTimeMillis();
						updateValues();
						if ((object instanceof SenseAdder)
								|| (object instanceof Entangle)) {
							layoutExtrasPanel();
						}
					}
				});

		affectsCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (power.canAffectPrimary()) {
					if (affectsCombo.getSelectedIndex() == 1) {
						power.setAffectPrimary(false);
						power.setAffectTotal(true);
					} else if (affectsCombo.getSelectedIndex() == 2) {
						power.setAffectPrimary(false);
						power.setAffectTotal(false);
					} else {
						power.setAffectPrimary(true);
						power.setAffectTotal(true);
					}
				} else {
					if (affectsCombo.getSelectedIndex() == 0) {
						power.setAffectPrimary(false);
						power.setAffectTotal(true);
					} else {
						power.setAffectPrimary(false);
						power.setAffectTotal(false);
					}
				}
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		quantityLbl = new JLabel("Quantity:");
		quantityTF = new LevelTF(power.getQuantity(), 9999, 1);
		damageLbl = new JLabel(power.getDamageDisplay());
		affectsLbl = new JLabel("Totaling Options:");
		ArrayList<String> vec = new ArrayList<String>();

		if (power.canAffectPrimary()) {
			vec.add("Add to Primary Value");
		}
		vec.add("Add to Secondary Value");
		vec.add("Do not add to Totals");

		affectsCombo = new JComboBox(vec.toArray());
		if (power.canAffectPrimary() && power.getAffectPrimary()) {
			affectsCombo.setSelectedIndex(0);
		} else if (!power.canAffectPrimary() && power.getAffectTotal()) {
			affectsCombo.setSelectedIndex(0);
		} else if (power.getAffectTotal()) {
			affectsCombo.setSelectedIndex(1);
		} else if (!power.canAffectPrimary()) {
			affectsCombo.setSelectedIndex(1);
		} else {
			affectsCombo.setSelectedIndex(2);
		}
		if (!power.isSummable()) {
			affectsLbl.setVisible(false);
			affectsCombo.setVisible(false);
		}

		useStandardEffectCB = new JCheckBox("Use Standard Effect");
		useStandardEffectCB.setSelected(power.useStandardEffect());
	}

	@Override
	public void updateValues() {
		super.updateValues();
		damageLbl.setText(power.getDamageDisplay());

		if (power.isSummable()) {
			affectsLbl.setVisible(true);
			affectsCombo.setVisible(true);
		} else {
			affectsLbl.setVisible(false);
			affectsCombo.setVisible(false);
		}
	}
}